//
// Fragment shader for Image Distortion effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;

uniform vec4 textureRect;

uniform vec2 drawingOffset;
uniform vec2 drawingScale;
uniform vec4 drawingBoundsRect; 

varying vec2 gUV;
bool InBound(float x, float a, float b)
{
    return (x > a && x<=b);
}
void main(void)
{
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w ) {
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    }
    else {
        float textureWidth = textureRect.z;
        float textureHeight = textureRect.w; 

      // This pixel location
        vec3 pCoord = gl_FragCoord.xyz;
        // Transform back to render traget coord space
        pCoord /= vec3(drawingScale, 1);
        pCoord += vec3(drawingOffset, 0);

        vec2 drawingBoundsOrigin = drawingBoundsRect.xy;
        float drawingBoundsWidth =  drawingBoundsRect.z;
        float drawingBoundsHeight = drawingBoundsRect.w;

        float deltaX = 0.0;//-0.75;//0.0;//sin( t )/2.0;//-.75;
        float deltaY = 0.0;//-0.5;//0.0;//sin( t )/2.0;//-.5;//1.0;

        //First transform image coords i, j into x, y from -1 to 1

        float x = -1.0+2.0/drawingBoundsWidth*(pCoord.x-drawingBoundsOrigin.x);
        float y = -1.0+2.0/drawingBoundsHeight*(pCoord.y-drawingBoundsOrigin.y);

        //Then transform to polar coordinates
        float ratio = min(textureWidth/textureHeight, textureHeight/textureWidth);
        float r = ratio*sqrt(x*x + y*y);
        float phi = atan(y,x);//equivalent to atan2
        
        float t = 90.0;//mod( float( time ), 30000.0 ) / 1000.0; //0 - 30 seconds
        float fac =  abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
        r = pow( r, fac );//fac );//magnifier
        
        //Map from polar to x, y
        x = r*cos( phi );
        y = r*sin( phi );

        //Map from x,y back to i , j texture coordinates
        float i = (x + 1.0 + deltaX)*drawingBoundsWidth*.5+drawingBoundsOrigin.x;
        float j = (y + 1.0 + deltaY)*drawingBoundsHeight*.5+drawingBoundsOrigin.y;

        vec2 uv = gUV +(vec2(i,j)-pCoord.xy)/vec2(drawingBoundsWidth, drawingBoundsHeight)*vec2(textureRect.x+textureRect.z,textureRect.y+textureRect.w);

        gl_FragColor = modulateColor*texture2DRect( texUnit, uv );
        gl_FragColor =(InBound(uv.x, textureRect.x, textureRect.x+textureRect.z) && InBound(uv.y, textureRect.y, textureRect.y+textureRect.w))?  gl_FragColor:vec4(0,0,0,0);

    }
    
}

